/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HSCVPD;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class ComputerSystemProvUtils {
    public static final String CEC_KEY_NAME = "Name";
    public static final String LPAR_KEY_NAME = "Name";
    public static final String DEVICE_ID = "DeviceID";
    public static final String SLOT_ID = "SlotID";
    public static final String IO_DRAWER_ID = "IODrawerDeviceID";
    public static final String CONSOLE_KEY_NAME = "Name";
    static final int LPAR_INFO_USER_DEF_NAME = 0;
    static final int LPAR_INFO_PHYSICAL_LOC_CODE = 1;
    static final int LPAR_INFO_CLUSTER_TYPE = 2;
    public static String HSC_MTMS = null;

    public static void updateCecResources(HscProviderSocket hscProviderSocket, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "->updateCecResources");
        Hashtable hashtable = null;
        short s = -1;
        short s2 = -1;
        long l = -1L;
        int n = -1;
        Integer n2 = null;
        try {
            CIMInstance cIMInstance2;
            Object object;
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMInstance.getProperty("State").getValue().getValue();
            if (unsignedInt8.shortValue() == 1) {
                hashtable = HscProviderUtils.doCSPCommand("GET_CEC_RESOURCES", null, hscProviderSocket);
                n2 = (Integer)hashtable.get("NUM_PROCESSORS");
                s = n2.shortValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("The installed CPU : " + s);
                }
                Trace.trace("apcshscD", "The installed CPU :" + s);
                n2 = (Integer)hashtable.get("NUM_IO_DRAWERS");
                s2 = n2.shortValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("The number of ioDrawer: " + s2);
                }
                Trace.trace("apcshscD", "The ioDrawer :" + s2);
                object = (Long)hashtable.get("MEMORY");
                l = (Long)object;
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("The installedMemory: " + l);
                }
                Trace.trace("apcshscD", "The installedMemory: " + l);
                cIMInstance.setProperty("InstalledCPUCount", new CIMValue((Object)new UnsignedInt8(s)));
                cIMInstance.setProperty("IODrawerCount", new CIMValue((Object)new UnsignedInt8(s2)));
                cIMInstance.setProperty("InstalledMemory", new CIMValue((Object)new UnsignedInt32(l)));
            }
            try {
                object = new String[]{Integer.toHexString(1)};
                hashtable = HscProviderUtils.doCSPCommand("GET_CEC_POLICY_SETTINGS", (String[])object, hscProviderSocket);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the get policy setting..");
                }
                n2 = (Integer)hashtable.get("POWER_POLICY");
                n = n2.shortValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the get policy setting is .." + n);
                }
                Trace.trace("apcshscD", "the get policy setting is .." + n);
                cIMInstance2 = null;
                cIMInstance2 = n == 0 ? CIMValue.FALSE : CIMValue.TRUE;
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" Before the cec set PowerOff...");
                }
                Trace.trace("apcshscD", "Before the cec set PowerOff...");
                cIMInstance.setProperty("PowerOffPolicy", (CIMValue)cIMInstance2);
            }
            catch (Exception exception) {
                System.out.println(" excep in policy setting !!!");
                System.out.println(exception.getMessage());
                exception.printStackTrace();
                HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                cIMInstance2 = cIMInstance;
                cIMInstance2.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance2, cIMInstance, hscProviderSocket);
            }
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" Before the cec set Instance...");
            }
            Trace.trace("apcshscD", "Before the cec set Instance...");
            try {
                CimomWrapper.setInstance(cIMOMHandle, cIMObjectPath, cIMInstance);
            }
            catch (CIMException cIMException) {
                System.out.println(" failed to update the cec.");
                cIMException.printStackTrace();
                HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
                cIMInstance2 = cIMInstance;
                cIMInstance2.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance2, cIMInstance, hscProviderSocket);
            }
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" after the cec set Instance...");
            }
            Trace.trace("apcshscD", "after the cec set Instance...");
            Trace.trace("apcshscD", "after the cec set Instance...");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            throw new HSCCIMException(exception);
        }
        Trace.trace("apcshscT", "<-updateCecResources");
    }

    public static void buildCecResources(HscProviderSocket hscProviderSocket, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, CIMOMHandle cIMOMHandle) throws CIMException {
        block34: {
            ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
            Trace.trace("apcshscT", "->buildCecResources");
            CIMClass cIMClass = null;
            CIMInstance cIMInstance2 = null;
            Hashtable hashtable = null;
            long l = -1L;
            long l2 = -1L;
            long l3 = -1L;
            long l4 = -1L;
            int n = -1;
            int n2 = -1;
            String[] stringArray = null;
            String string = null;
            int n3 = -1;
            Object var23_17 = null;
            int n4 = -1;
            Object var25_19 = null;
            CIMObjectPath cIMObjectPath2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            Integer n5 = null;
            String string2 = null;
            Object var30_24 = null;
            try {
                int n6;
                Object object;
                String string3;
                Object object2;
                String[] stringArray2;
                Hashtable hashtable2 = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
                string2 = (String)hashtable2.get("VERSION");
                short s = ((UnsignedInt8)cIMInstance.getProperty("State").getValue().getValue()).shortValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("In buildCecResources the cec state is:" + s);
                }
                short s2 = ((UnsignedInt8)cIMInstance.getProperty("Mode").getValue().getValue()).shortValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("In buildCecResources the cec mode is:" + s2);
                }
                try {
                    hashtable = HscProviderUtils.doCSPCommand("GET_CEC_MEMORY_RESOURCES", null, hscProviderSocket, string2);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after the GET_CEC_MEMORY_RESOURCES .." + hashtable);
                    }
                    if (hashtable != null) {
                        Trace.trace("apcshscD", "after the GET_CEC_MEMORY_RESOURCES ..", hashtable.toString());
                    }
                    stringArray2 = (String[])hashtable.get("MEMORY_INSTALLED");
                    l = stringArray2.shortValue();
                    stringArray2 = (Long)hashtable.get("TOT_AVAILABLE_MEMORY");
                    l2 = stringArray2.longValue();
                    stringArray2 = (Long)hashtable.get("FAILED_MEMORY");
                    long l5 = stringArray2.longValue();
                    stringArray2 = (Long)hashtable.get("REGION_SIZE");
                    l4 = stringArray2.longValue();
                    System.out.println(" the lmbSize is .." + l4);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" the totol Mem is .." + l);
                        System.out.println(" the freeMemory Mem is .." + l2);
                        System.out.println(" the failedMemory Mem is .." + l5);
                        System.out.println(" the lmbSize is .." + l4);
                    }
                    Trace.trace("apcshscD", "the totol Mem is .." + l);
                    Trace.trace("apcshscD", "the freeMemory Mem is .." + l2);
                    Trace.trace("apcshscD", "the failedMemory Mem is .." + l5);
                    Trace.trace("apcshscD", "the lmbSize is .." + l4);
                    cIMInstance.setProperty("LMBSize", new CIMValue((Object)new UnsignedInt32(l4)));
                    l3 = l2 - l5;
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" the usable memory is .." + l3);
                    }
                    Trace.trace("apcshscD", " the usable memory is .." + l3);
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_Memory", "root/ibmhscV3_2");
                    cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" Before  memory newInstance method call ..");
                    }
                    Trace.trace("apcshscD", " Before  memory newInstance method call ..");
                    cIMInstance2 = cIMClass.newInstance();
                    cIMInstance2.setProperty("TotalMemory", new CIMValue((Object)new UnsignedInt32(l)));
                    cIMInstance2.setProperty("FreeMemory", new CIMValue((Object)new UnsignedInt32(l2)));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after the free Memory ..." + l2);
                    }
                    Trace.trace("apcshscD", " after the free Memory ...");
                    cIMInstance2.setProperty("UsableMemory", new CIMValue((Object)new UnsignedInt32(l3)));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after the Usable Memory ...");
                    }
                    Trace.trace("apcshscD", " after the Usable Memory ...");
                    object2 = Long.toString(l) + " " + Long.toString(l2) + " " + Long.toString(l3);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" the total,free and usable memory" + (String)object2);
                    }
                    Trace.trace("apcshscD", "The total , free and usable memory", object2);
                    cIMInstance2.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Memory"));
                    CIMProperty cIMProperty = cIMInstance.getProperty("Name");
                    string = (String)cIMProperty.getValue().getValue();
                    cIMInstance2.setProperty("SystemName", new CIMValue((Object)string));
                    cIMInstance2.setProperty("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                    cIMInstance2.setProperty(DEVICE_ID, new CIMValue((Object)"Mem00"));
                    cIMObjectPath3 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
                    cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" Before  memory creation ..");
                    }
                    Trace.trace("apcshscD", " Before  memory creation ..");
                    string3 = CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMInstance2);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after memory creation ..");
                    }
                    Trace.trace("apcshscD", " after  memory creation ..");
                    string3 = cIMObjectPath3;
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysMemory", "root/ibmhscV3_2");
                    cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                    object = cIMClass.newInstance();
                    object.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
                    object.setProperty("PartComponent", new CIMValue((Object)string3));
                    cIMObjectPath3 = new CIMObjectPath(object.getClassName(), object.getKeyValuePairs());
                    cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                    CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, object);
                }
                catch (Exception exception) {
                    System.out.println(" excep in Memory Creation!!!");
                    Trace.trace("apcshscT", " excep in Memory Creation!!!");
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                    HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                    CIMInstance cIMInstance3 = cIMInstance;
                    cIMInstance3.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                    HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance3, cIMInstance, hscProviderSocket);
                }
                hashtable = HscProviderUtils.doCSPCommand("GET_INSTALLED_PROC_STATE_VALUE", null, hscProviderSocket);
                n5 = (Integer)hashtable.get("NUM_PROCESSORS");
                n = n5;
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("the numOfProcessors ....." + n);
                }
                Trace.trace("apcshscD", "the numOfProcessors ....." + n);
                System.out.println("the numOfProcessors ....." + n);
                stringArray2 = new String[n];
                int n7 = 0;
                while (n7 < n) {
                    stringArray2[n7] = Integer.toHexString(n7);
                    ++n7;
                }
                Hashtable hashtable3 = ComputerSystemProvUtils._getProcStatus(hscProviderSocket, stringArray2);
                object2 = ComputerSystemProvUtils._getProcState(hscProviderSocket, stringArray2);
                int n8 = 0;
                while (n8 < n) {
                    try {
                        string3 = Integer.toHexString(n8);
                        short s3 = ((Integer)((Hashtable)object2).get(string3)).shortValue();
                        n6 = ((Integer)hashtable3.get(string3)).shortValue();
                        if (n6 != 0 && n6 != 16) {
                            ComputerSystemProvUtils.addCPU(cIMOMHandle, s3, (short)n6, n8, cIMObjectPath);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(" excep in process creation ... but Continue!!!");
                        Trace.trace("apcshscT", " excep in process creation ... but Continue!!!");
                        System.out.println(exception.getMessage());
                        exception.printStackTrace();
                        HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                        object = cIMInstance;
                        object.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                        HscProviderUtils.handleCecInCompleteState(cIMOMHandle, object, cIMInstance, hscProviderSocket);
                    }
                    ++n8;
                }
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the get drawer's id ...");
                }
                Trace.trace("apcshscD", " before the get drawer's id ...");
                hashtable = HscProviderUtils.doCSPCommand("GET_NUM_IO_DRAWERS", null, hscProviderSocket);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the response for the get num of IO draw ..." + hashtable);
                }
                if (hashtable != null) {
                    Trace.trace("apcshscD", " the response for the get num of IO draw ...", hashtable.toString());
                }
                n5 = (Integer)hashtable.get("NUM_IO_DRAWERS");
                n2 = n5.shortValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" The num of IO drawer's is ..." + n2);
                }
                Trace.trace("apcshscD", " The num of IO drawer's is ..." + n2);
                stringArray = (String[])hashtable.get("DRAWER_IDS");
                int n9 = 0;
                while (n9 < n2) {
                    object = stringArray[n9];
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" The  IO drawer's is ..." + (String)object);
                    }
                    Trace.trace("apcshscD", " The  IO drawer's is ...", object);
                    try {
                        ComputerSystemProvUtils.addDrawerAndSlots(cIMOMHandle, (String)object, cIMObjectPath, hscProviderSocket);
                    }
                    catch (Throwable throwable) {
                        System.out.println(" excep in Drawer and Slot Creation but Continue...");
                        Trace.trace("apcshscD", " excep in Drawer and Slot Creation but Continue...");
                        System.out.println(throwable.getMessage());
                        throwable.printStackTrace();
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                        CIMInstance cIMInstance4 = cIMInstance;
                        cIMInstance4.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                        HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance4, cIMInstance, hscProviderSocket);
                    }
                    ++n9;
                }
                object = (String)cIMInstance.getProperty("CSPVersion").getValue().getValue();
                n6 = VersionComparator.CSPVersionValue((String)object);
                Trace.trace("apcshscD", "CSP version: " + n6);
                if (!((float)n6 >= 2000.0f)) break block34;
                try {
                    short s4 = 0;
                    Hashtable hashtable4 = HscProviderUtils.getCapabilities((String)object, hscProviderSocket);
                    int n10 = (Integer)hashtable4.get("RuntimeCapability");
                    if (((short)n10 & 8) == 8) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_PROCESSOR_AFFINITY", null, hscProviderSocket);
                        n5 = (Integer)hashtable.get("AFFINITY_TYPE");
                        s4 = n5.shortValue();
                        cIMInstance.setProperty("AffinityCapability", new CIMValue((Object)new UnsignedInt8(s4)));
                        Trace.trace("apcshscD", "AffinityCapability set to " + s4);
                        break block34;
                    }
                    cIMInstance.setProperty("AffinityCapability", new CIMValue((Object)new UnsignedInt8(s4)));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
            }
            catch (CIMException cIMException) {
                System.out.println(cIMException.getMessage());
                cIMException.printStackTrace();
                HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException(cIMException);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
                HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException(exception);
            }
        }
        Trace.trace("apcshscT", "<-buildCecResources.");
    }

    /*
     * Exception decompiling
     */
    public static void createPartitionAndProfiles(HscProviderSocket var0, CIMObjectPath var1_1, CIMInstance var2_2, NVRAM var3_3, CIMOMHandle var4_4) throws CIMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createSystemProfiles(HscProviderSocket hscProviderSocket, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, NVRAM nVRAM, CIMOMHandle cIMOMHandle) throws CIMException {
        Vector vector;
        ProviderCIMOMHandle providerCIMOMHandle;
        block22: {
            providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
            Trace.trace("apcshscT", "->createSystemProfiles");
            Object var6_6 = null;
            Object var7_7 = null;
            Object var8_8 = null;
            Hashtable hashtable = null;
            try {
                hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toHexString(1), HscProviderUtils.getHscID(cIMOMHandle)}, hscProviderSocket);
            }
            catch (Throwable throwable) {
                CIMInstance cIMInstance2 = cIMInstance;
                cIMInstance2.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance2, cIMInstance, hscProviderSocket);
                throw new HSCCIMException("Unable to get CSP Lock");
            }
            vector = nVRAM.getAllSysProfiles(hscProviderSocket);
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" the vec after getallSysprofiles is .." + vector);
            }
            if (vector != null) {
                Trace.trace("apcshscD", " the vec after getallSysprofiles is ..", vector.toString());
            }
            if (vector != null) break block22;
            try {
                HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toHexString(2), HscProviderUtils.getHscID(cIMOMHandle)}, hscProviderSocket);
                return;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            }
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            try {
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" inside of the loop..");
                }
                Trace.trace("apcshscD", " inside of the loop..");
                Vector vector2 = (Vector)vector.elementAt(n);
                System.out.println(" inside of the loop..1" + vector2);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" inside of the loop..1" + vector2);
                }
                if (vector2 != null) {
                    Trace.trace("apcshscD", " inside of the loop..1", vector2.toString());
                    ComputerSystemProvUtils.addSystemProfiles((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, vector2, true);
                }
            }
            catch (Exception exception) {
                System.out.println(" Error in the system profile creation...But continue");
                exception.printStackTrace();
                HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                CIMInstance cIMInstance3 = cIMInstance;
                cIMInstance3.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance3, cIMInstance, hscProviderSocket);
            }
            ++n;
        }
        try {
            HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toHexString(2), HscProviderUtils.getHscID(cIMOMHandle)}, hscProviderSocket);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
        }
        Trace.trace("apcshscT", "<-createSystemProfiles");
        return;
        catch (CIMException cIMException) {
            try {
                System.out.println(cIMException.getMessage());
                cIMException.printStackTrace();
                HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException(cIMException);
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                    HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                    throw new HSCCIMException(exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toHexString(2), HscProviderUtils.getHscID(cIMOMHandle)}, hscProviderSocket);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    HSCLogUtils.serverLog(throwable2, HSCLogUtils._CECClassLogInfo);
                }
                throw throwable;
            }
        }
    }

    public static void closeVTTYTerminal(HscProviderSocket hscProviderSocket, String[] stringArray, short s) {
        Hashtable hashtable = null;
        try {
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println("-> Closing the VTTY sessions..");
            }
            Trace.trace("apcshscD", "-> Closing the VTTY sessions..");
            hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_TTY_SESSION_NUMBERS", stringArray, hscProviderSocket);
            Vector vector = (Vector)hashtable.get("LIST_SESSION_NUMBERS");
            if (vector != null || vector.size() != 0) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Integer n = (Integer)enumeration.nextElement();
                    try {
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" the Session to be closed is .." + n);
                        }
                        Trace.trace("apcshscD", " the Session to be closed is ..", n.toString());
                        if (n == 0) continue;
                        hashtable = null;
                        hashtable = HscProviderUtils.doCSPCommand("CLOSE_VIRTUAL_TTY", new String[]{stringArray[0], Integer.toHexString(n), Integer.toHexString(0)}, hscProviderSocket);
                    }
                    catch (Exception exception) {
                        System.out.println(" Error in closing the TTY session");
                        exception.printStackTrace();
                    }
                }
            }
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println("<- Closing the VTTY sessions..");
            }
            Trace.trace("apcshscD", "<- Closing the VTTY sessions..");
        }
        catch (Exception exception) {
            System.out.print(" Error in closing the VTTY Session.");
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
        }
    }

    public static void addCPU(CIMOMHandle cIMOMHandle, short s, short s2, int n, CIMObjectPath cIMObjectPath) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMObjectPath cIMObjectPath3 = null;
        CIMObjectPath cIMObjectPath4 = null;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        Vector vector = cIMObjectPath.getKeys();
        String string = null;
        if (vector != null) {
            cIMObjectPath2 = vector.elements();
            while (cIMObjectPath2.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)cIMObjectPath2.nextElement();
                if (!"Name".equalsIgnoreCase(cIMProperty.getName())) continue;
                string = (String)cIMProperty.getValue().getValue();
                break;
            }
        }
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("the cec Name in addCPU is" + string);
        }
        Trace.trace("apcshscD", "the cec Name in addCPU is", string);
        cIMObjectPath3 = new CIMObjectPath("IBMHSC_Processor", "root/ibmhscV3_2");
        cIMClass = providerCIMOMHandle.getClass(cIMObjectPath3, false);
        cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty(DEVICE_ID, new CIMValue((Object)new UnsignedInt8((short)n)));
        cIMInstance.setProperty("CPUState", new CIMValue((Object)new UnsignedInt8(s)));
        cIMInstance.setProperty("CPUStatus", new CIMValue((Object)new UnsignedInt8(s2)));
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)string));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Processor"));
        cIMObjectPath4 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
        cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
        cIMObjectPath2 = CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath4, cIMInstance);
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" after the processor Creation.." + cIMObjectPath4);
        }
        Trace.trace("apcshscD", " after the processor Creation..", cIMObjectPath4.toString());
        cIMObjectPath2 = cIMObjectPath4;
        cIMObjectPath3 = new CIMObjectPath("IBMHSC_CompSysProcessor", "root/ibmhscV3_2");
        cIMClass = providerCIMOMHandle.getClass(cIMObjectPath3, false);
        cIMInstance2 = cIMClass.newInstance();
        cIMInstance2.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
        cIMInstance2.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
        cIMObjectPath4 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
        cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
        CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath4, cIMInstance2);
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" after creating of the processor asso");
        }
        Trace.trace("apcshscD", " after creating of the processor asso");
    }

    public static void addDrawerAndSlots(CIMOMHandle cIMOMHandle, String string, CIMObjectPath cIMObjectPath, HscProviderSocket hscProviderSocket) throws CIMException {
        FileInputStream fileInputStream;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        CIMInstance cIMInstance;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        Properties properties = null;
        Properties properties2 = null;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Integer n = null;
        int n2 = -1;
        String string2 = null;
        int n3 = -1;
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMClass cIMClass = null;
        File file = null;
        Object var17_17 = null;
        String string3 = null;
        Vector vector = cIMObjectPath.getKeys();
        if (vector != null) {
            cIMInstance = vector.elements();
            while (cIMInstance.hasMoreElements()) {
                object4 = (CIMProperty)cIMInstance.nextElement();
                if (!"Name".equalsIgnoreCase(object4.getName())) continue;
                string3 = (String)object4.getValue().getValue();
                break;
            }
        }
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("the cec Name in addDrawerAndSlots is" + string3);
        }
        Trace.trace("apcshscD", "the cec Name in addDrawerAndSlots is", string3);
        cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath, cIMOMHandle.getClass(cIMObjectPath, false), false);
        object4 = (String)cIMInstance.getProperty("CSPVersion").getValue().getValue();
        int n4 = VersionComparator.CSPVersionValue((String)object4);
        if (properties == null) {
            try {
                properties = new Properties();
                properties2 = new Properties();
                object3 = null;
                object2 = null;
                object = null;
                fileInputStream = null;
                object3 = new File("/opt/hsc/data/HscPciClassCodeInfo");
                fileInputStream = new FileInputStream((File)object3);
                object2 = new File("/opt/hsc/data/HSCVendorLookUp");
                object = new FileInputStream((File)object2);
                properties.load(fileInputStream);
                properties2.load((InputStream)object);
                ((FileInputStream)object).close();
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string4 = " The Properties File HscPciClassCodeInfo is not available";
                fileNotFoundException.printStackTrace();
                HSCLogUtils.serverLog(fileNotFoundException, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException(fileNotFoundException);
            }
            catch (IOException iOException) {
                System.out.println(" IOError : Failed during the Properties  Initialization of the class code.");
                iOException.printStackTrace();
                HSCLogUtils.serverLog(iOException, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException(iOException);
            }
            catch (Exception exception) {
                System.out.println(" excep in initization of class  code property file... but Continue!!!");
                System.out.println(exception.getMessage());
                exception.printStackTrace();
                HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException(exception);
            }
        }
        try {
            object3 = new String[]{string};
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" the drawer id is .." + object3[0]);
            }
            Trace.trace("apcshscD", "the drawer id is ..", object3[0]);
            hashtable = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", object3, hscProviderSocket);
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" after the get IO Dr info.." + hashtable);
            }
            if (hashtable != null) {
                Trace.trace("apcshscD", " after the get IO Dr info..", hashtable.toString());
            }
            n = (Integer)hashtable.get("DRAWER_CLASS");
            n2 = n;
            string2 = (String)hashtable.get("DRAWER_LOC_CODE");
            string2 = string2.trim();
            n = (Integer)hashtable.get("NUM_SLOTS");
            n3 = n.shortValue();
            hashtable2 = (Hashtable)hashtable.get("SLOT_INFORMATION");
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println("The slots infor hashtable .." + hashtable2);
            }
            if (hashtable2 != null) {
                Trace.trace("apcshscD", "The slots infor hashtable ..", hashtable2.toString());
            }
            cIMObjectPath2 = new CIMObjectPath("IBMHSC_IODrawer", "root/ibmhscV3_2");
            cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
            file = cIMClass.newInstance();
            file.setProperty(DEVICE_ID, new CIMValue((Object)object3[0]));
            file.setProperty("PhysicalLocation", new CIMValue((Object)string2));
            file.setProperty("ClassCode", new CIMValue((Object)new UnsignedInt16(n2)));
            object2 = null;
            if (properties != null) {
                object = Integer.toString(n2);
                object2 = (String)properties.get(object);
            }
            System.out.println(" the drawerClassInfo is .." + (String)object2);
            if (object2 == null) {
                object2 = " UN_KNOWN";
            }
            file.setProperty("Description", new CIMValue(object2));
            file.setProperty("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            file.setProperty("SystemName", new CIMValue((Object)string3));
            file.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
            cIMObjectPath3 = new CIMObjectPath(file.getClassName(), file.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            object = CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, (CIMInstance)file);
            object = cIMObjectPath3;
            fileInputStream = new CIMObjectPath("IBMHSC_CompSysIODrawer", "root/ibmhscV3_2");
            cIMClass = providerCIMOMHandle.getClass((CIMObjectPath)fileInputStream, false);
            CIMInstance cIMInstance2 = cIMClass.newInstance();
            cIMInstance2.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            cIMInstance2.setProperty("PartComponent", new CIMValue(object));
            cIMObjectPath3 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" before the CompSysIODrawer cre..");
            }
            Trace.trace("apcshscD", " before the CompSysIODrawer cre..");
            CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance2);
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" after the CompSysIODrawer cre..");
            }
            Trace.trace("apcshscD", " after the CompSysIODrawer cre..");
            short s = -1;
            Vector vector2 = new Vector();
            Object var30_35 = null;
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" before the Slots loop ");
            }
            Trace.trace("apcshscD", "  before the Slots loop");
            int n5 = 0;
            while (n5 < n3) {
                String string5;
                Hashtable hashtable3 = (Hashtable)hashtable2.get(new Integer(n5));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("The slots info of each hashtable .." + hashtable3);
                }
                if (hashtable3 != null) {
                    Trace.trace("apcshscD", "The slots info of each hashtable ..", hashtable3.toString());
                }
                n = (Integer)hashtable3.get("SLOT_NO");
                s = n.shortValue();
                n = (Integer)hashtable3.get("PCI_BUS_NO");
                short s2 = n.shortValue();
                Integer n6 = n;
                CIMClass cIMClass2 = null;
                CIMInstance cIMInstance3 = null;
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
                cIMClass2 = providerCIMOMHandle.getClass(cIMObjectPath4, false);
                cIMInstance3 = cIMClass2.newInstance();
                cIMInstance3.setProperty(IO_DRAWER_ID, new CIMValue((Object)object3[0]));
                cIMInstance3.setProperty(SLOT_ID, new CIMValue((Object)new UnsignedInt8(s)));
                cIMInstance3.setProperty("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
                cIMInstance3.setProperty("IODrawerSystemName", new CIMValue((Object)string3));
                cIMInstance3.setProperty("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                String string6 = (String)hashtable3.get("SLOT_LOC_CODE");
                string6 = string6.trim();
                if (string2.equals("")) {
                    if (string6.equals("")) {
                        string6 = "UnKnown";
                    }
                    cIMInstance3.setProperty("SlotLocation", new CIMValue((Object)string6));
                } else if (string6.equals("")) {
                    string6 = "UnKnown";
                    cIMInstance3.setProperty("SlotLocation", new CIMValue((Object)string6));
                } else {
                    string5 = string2.concat("-") + string6;
                    cIMInstance3.setProperty("SlotLocation", new CIMValue((Object)string5));
                }
                n = (Integer)hashtable3.get("IO_STATUS");
                cIMInstance3.setProperty("PCISlotStatus", new CIMValue((Object)new UnsignedInt8(n.shortValue())));
                n = (Integer)hashtable3.get("PCI_BUS_NO");
                cIMInstance3.setProperty("PCIBus", new CIMValue((Object)new UnsignedInt8(n.shortValue())));
                string5 = (String)hashtable3.get("PCI_CLASS_CODE");
                cIMInstance3.setProperty("ClassCode", new CIMValue((Object)string5));
                String string7 = null;
                if (properties != null) {
                    string7 = (String)properties.get(string5);
                }
                if (string7 == null) {
                    string7 = string5;
                }
                n = (Integer)hashtable3.get("DEVICE_ID");
                Integer n7 = (Integer)hashtable3.get("VENDOR_ID");
                if (n == 65535 && n7 == 65535) {
                    string7 = "Empty";
                }
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the classCode Info is .." + string7);
                }
                Trace.trace("apcshscD", " the classCode Info is ..", string7);
                cIMInstance3.setProperty("DeviceId", new CIMValue((Object)new UnsignedInt16(n.intValue())));
                cIMInstance3.setProperty("VendorID", new CIMValue((Object)new UnsignedInt16(n7.intValue())));
                cIMInstance3.setProperty("ClassCodeInfo", new CIMValue((Object)string7));
                n = (Integer)hashtable3.get("IO_STATE");
                cIMInstance3.setProperty("State", new CIMValue((Object)new UnsignedInt8(n.shortValue())));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" Slot state value is .. " + n.shortValue());
                }
                Trace.trace("apcshscD", "Slot state value is .." + n.shortValue());
                if ((float)n4 >= 3000.0f) {
                    long l = (Long)hashtable3.get("DRC_INDEX");
                    System.out.println("The DRCIndex value is :" + l);
                    cIMInstance3.setProperty("DRCIndex", new CIMValue((Object)new UnsignedInt32(l)));
                }
                cIMObjectPath3 = new CIMObjectPath(cIMInstance3.getClassName(), cIMInstance3.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                CIMObjectPath cIMObjectPath5 = CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance3);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("After the slot creation..");
                }
                Trace.trace("apcshscD", "After the slot creation..");
                cIMObjectPath5 = cIMObjectPath3;
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the adding of keys to slots.");
                }
                Trace.trace("apcshscD", " after the adding of keys to slots.");
                CIMObjectPath cIMObjectPath6 = new CIMObjectPath("IBMHSC_IODrawerSlot", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath6, false);
                file = cIMClass.newInstance();
                file.setProperty("GroupComponent", new CIMValue(object));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the part..");
                }
                Trace.trace("apcshscD", " before the part..");
                file.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath5));
                cIMObjectPath3 = new CIMObjectPath(file.getClassName(), file.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the ioD and slot asso..");
                }
                Trace.trace("apcshscD", "  before the ioD and slot asso..");
                CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, (CIMInstance)file);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the ioD and slot asso..");
                }
                Trace.trace("apcshscD", "  before the ioD and slot asso..");
                ++n5;
            }
        }
        catch (Exception exception) {
            System.out.println(" excep in Drawer and Slot Creation but Continue...");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
            object2 = file;
            object2.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
            HscProviderUtils.handleCecInCompleteState(cIMOMHandle, (CIMInstance)object2, (CIMInstance)file, hscProviderSocket);
        }
    }

    public static void addDefaultLparProfile(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_DefaultLparProfile", "root/ibmhscV3_2");
        CIMClass cIMClass = cIMOMHandle.getClass(cIMObjectPath3, false);
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath));
        cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath2));
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
        cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
        System.out.println(" before the default lpar creation..");
        CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath4, cIMInstance);
        System.out.println(" after  the default lpar creation..");
    }

    public static void addLparProfile(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, Vector vector, HscProviderSocket hscProviderSocket) throws CIMException {
        Object object;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        Vector vector2 = cIMObjectPath.getKeys();
        String string = null;
        if (vector2 != null) {
            object = vector2.elements();
            while (object.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)object.nextElement();
                if (!"Name".equalsIgnoreCase(cIMProperty.getName())) continue;
                string = (String)cIMProperty.getValue().getValue();
                break;
            }
        }
        object = string.substring(string.indexOf(42) + 1);
        short s = Short.parseShort(string.substring(0, 3));
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" the lparID in addLparProfile is ." + s);
            System.out.println("the partition  Name in addLparProfile is" + string);
        }
        Trace.trace("apcshscD", " the lparID in addLparProfile is ." + s);
        Trace.trace("apcshscD", " the partition  Name in addLparProfile is", string);
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
        cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath4.addKey("Name", new CIMValue(object));
        CIMInstance cIMInstance2 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath4, cIMOMHandle.getClass(cIMObjectPath4, false), false);
        String string2 = (String)cIMInstance2.getProperty("CSPVersion").getValue().getValue();
        System.out.println("cspVersion: " + string2);
        int n = VersionComparator.CSPVersionValue(string2);
        if (!vector.isEmpty()) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                UnsignedInt8 unsignedInt8;
                CIMClass cIMClass2;
                CIMInstance cIMInstance3;
                Object object2;
                CIMObjectPath cIMObjectPath5;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                UnsignedInt8 unsignedInt82;
                UnsignedInt8 unsignedInt83;
                UnsignedInt8 unsignedInt84;
                UnsignedInt8 unsignedInt85;
                UnsignedInt8 unsignedInt86;
                UnsignedInt8 unsignedInt87;
                String string3;
                String string4;
                CIMProperty cIMProperty;
                Vector vector3 = (Vector)enumeration.nextElement();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the temp vec with prof is ..." + vector3);
                }
                if (vector3 != null) {
                    Trace.trace("apcshscD", "  the temp vec with prof is ..", vector3.toString());
                }
                if ((float)n >= 3000.0f) {
                    CIMInstance cIMInstance4;
                    Boolean bl;
                    cIMProperty = (CIMProperty)vector3.elementAt(0);
                    string4 = (String)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(1);
                    string3 = (String)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println("setting str and the userDefinedName is .." + string4 + " " + string3);
                    }
                    Trace.trace("apcshscD", "setting str is ..", string4);
                    Trace.trace("apcshscD", "userDefinedName is ..", string3);
                    cIMProperty = (CIMProperty)vector3.elementAt(2);
                    unsignedInt87 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" the bootMode value is .." + unsignedInt87);
                    }
                    if (unsignedInt87 != null) {
                        Trace.trace("apcshscD", " the bootMode value is ..", unsignedInt87.toString());
                    }
                    cIMProperty = (CIMProperty)vector3.elementAt(3);
                    unsignedInt86 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(4);
                    unsignedInt85 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(5);
                    unsignedInt84 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(6);
                    unsignedInt83 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(7);
                    unsignedInt82 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(8);
                    object6 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(9);
                    object5 = (UnsignedInt32)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(10);
                    object4 = (UnsignedInt32)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(11);
                    object3 = (UnsignedInt32)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before the Drawer info..");
                    }
                    Trace.trace("apcshscD", "before the Drawer info..");
                    cIMProperty = (CIMProperty)vector3.elementAt(12);
                    cIMObjectPath5 = (CIMObjectPath)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after  the Drawer info.." + cIMObjectPath5);
                    }
                    object2 = null;
                    if (cIMObjectPath5 == null) {
                        object2 = " No IO Drawer/slots  for this profile..";
                        cIMObjectPath5 = new Vector();
                    } else {
                        object2 = cIMObjectPath5.toString();
                    }
                    Trace.trace("apcshscD", " after  the Drawer info..", object2);
                    cIMProperty = (CIMProperty)vector3.elementAt(13);
                    cIMInstance3 = (CIMInstance)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after  the slots info.." + cIMInstance3);
                    }
                    if (cIMInstance3 == null) {
                        object2 = " No IO Drawer/slots  for this profile..";
                        cIMInstance3 = new Vector();
                    } else {
                        object2 = cIMInstance3.toString();
                    }
                    Trace.trace("apcshscD", "  after  the slots info..", object2);
                    cIMProperty = (CIMProperty)vector3.elementAt(14);
                    cIMClass2 = (CIMClass)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after  the requried  info.." + cIMClass2);
                    }
                    if (cIMClass2 == null) {
                        object2 = " No IO Drawer/slots  for this profile..";
                        cIMClass2 = new Vector();
                    } else {
                        object2 = cIMClass2.toString();
                    }
                    Trace.trace("apcshscD", " after  the requried  info..", object2);
                    unsignedInt8 = null;
                    Vector vector4 = null;
                    Vector vector5 = null;
                    if ((float)n > 3000.0f) {
                        cIMProperty = (CIMProperty)vector3.elementAt(15);
                        unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
                        cIMProperty = (CIMProperty)vector3.elementAt(16);
                        vector4 = (Vector)cIMProperty.getValue().getValue();
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" after the SMA adapter IDs..." + vector4);
                        }
                        if (vector4 == null) {
                            object2 = " No SMA Adapters for this profile..";
                            vector4 = new Vector();
                        } else {
                            object2 = vector4.toString();
                        }
                        Trace.trace("apcshscD", " after  the SMA adapter IDs ...", object2);
                        cIMProperty = (CIMProperty)vector3.elementAt(17);
                        vector5 = (Vector)cIMProperty.getValue().getValue();
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" after the SMA windows..." + vector5);
                        }
                        if (vector5 == null) {
                            object2 = " No SMA windows for this profile..";
                            vector5 = new Vector();
                        } else {
                            object2 = vector5.toString();
                        }
                        Trace.trace("apcshscD", " after  the SMA windows...", object2);
                    }
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
                    cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                    cIMInstance = cIMClass.newInstance();
                    cIMInstance.setProperty("SettingID", new CIMValue((Object)string4));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before the partion set in the lparProfile.." + string);
                    }
                    Trace.trace("apcshscD", " before the partion set in the lparProfile..", string);
                    cIMInstance.setProperty("PartitionName", new CIMValue((Object)string));
                    cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)string3));
                    cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                    cIMInstance.setProperty("BootMode", new CIMValue((Object)unsignedInt87));
                    cIMInstance.setProperty("ServiceAuthority", new CIMValue((Object)unsignedInt86));
                    cIMInstance.setProperty("RMOSize", new CIMValue((Object)unsignedInt85));
                    cIMInstance.setProperty("SFPSurveillance", new CIMValue((Object)unsignedInt84));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before assign of the Mem ..");
                    }
                    Trace.trace("apcshscD", " before assign of the Mem ..");
                    cIMInstance.setProperty("DesiredMemoryMB", new CIMValue(object5));
                    cIMInstance.setProperty("MinimumMemoryMB", new CIMValue(object4));
                    cIMInstance.setProperty("MaximumMemoryMB", new CIMValue(object3));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before assign of the cpus..");
                    }
                    Trace.trace("apcshscD", "before assign of the cpus..");
                    cIMInstance.setProperty("DesiredCPUCount", new CIMValue((Object)unsignedInt83));
                    cIMInstance.setProperty("MinimumCPUCount", new CIMValue((Object)unsignedInt82));
                    cIMInstance.setProperty("MaximumCPUCount", new CIMValue(object6));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before assign of the IOSlots..");
                    }
                    Trace.trace("apcshscD", "before assign of the IOSlots..");
                    cIMInstance.setProperty("IOSlots", new CIMValue(cIMInstance3, new CIMDataType(21)));
                    cIMInstance.setProperty("IODrawer", new CIMValue((Vector)cIMObjectPath5, new CIMDataType(29)));
                    cIMInstance.setProperty("IORequirement", new CIMValue(cIMClass2, new CIMDataType(29)));
                    if ((float)n > 3000.0f) {
                        cIMInstance.setProperty("SNIConfigMode", new CIMValue((Object)unsignedInt8));
                        cIMInstance.setProperty("SNIDeviceID", new CIMValue(vector4, new CIMDataType(29)));
                        cIMInstance.setProperty("SNIWindows", new CIMValue(vector5, new CIMDataType(23)));
                    }
                    cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                    cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before creating of the lpar..");
                    }
                    Trace.trace("apcshscD", "before  creating of the lpar..");
                    CIMObjectPath cIMObjectPath6 = CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMInstance);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after  creating of the lpar..");
                    }
                    Trace.trace("apcshscD", " after  creating of the lpar..");
                    cIMObjectPath6 = cIMObjectPath3;
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after the add key, lparProfile is.." + cIMObjectPath6);
                    }
                    Trace.trace("apcshscD", "  after the add key, lparProfile is..", cIMObjectPath6.toString());
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2");
                    cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                    cIMInstance = cIMClass.newInstance();
                    cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                    cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath6));
                    cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                    cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before the create of asso partiton profile");
                    }
                    Trace.trace("apcshscD", " before the create of asso partiton profile");
                    CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after the create of asso partiton profile");
                    }
                    Trace.trace("apcshscD", " after the create of asso partiton profile");
                    try {
                        cIMProperty = (float)n > 3000.0f ? (CIMProperty)vector3.elementAt(18) : (CIMProperty)vector3.elementAt(15);
                        bl = (Boolean)cIMProperty.getValue().getValue();
                        if (bl.booleanValue()) {
                            ComputerSystemProvUtils.addDefaultLparProfile(cIMOMHandle, cIMObjectPath, cIMObjectPath6);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(" Excp in Creation of Default Lpar  Profile assocation ");
                        exception.printStackTrace();
                        HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                        cIMInstance4 = cIMInstance;
                        cIMInstance4.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                        HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance4, cIMInstance, hscProviderSocket);
                    }
                    try {
                        cIMProperty = (float)n > 3000.0f ? (CIMProperty)vector3.elementAt(19) : (CIMProperty)vector3.elementAt(16);
                        bl = (Boolean)cIMProperty.getValue().getValue();
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" is activated !!!" + bl);
                        }
                        if (bl != null) {
                            Trace.trace("apcshscD", " is activated !!!", bl.toString());
                        }
                        if (!bl.booleanValue()) continue;
                        cIMInstance4 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
                        CIMClass cIMClass3 = providerCIMOMHandle.getClass((CIMObjectPath)cIMInstance4, false);
                        CIMInstance cIMInstance5 = cIMClass3.newInstance();
                        cIMInstance5.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                        cIMInstance5.setProperty("Setting", new CIMValue((Object)cIMObjectPath6));
                        cIMObjectPath3 = new CIMObjectPath(cIMInstance5.getClassName(), cIMInstance5.getKeyValuePairs());
                        cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" before activate asso creation..");
                        }
                        Trace.trace("apcshscD", " before activate asso creation..");
                        CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance5);
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" after activate asso creation..");
                        }
                        Trace.trace("apcshscD", "  after activate asso creation..");
                    }
                    catch (Exception exception) {
                        System.out.println(" Excp in Creation of activated Lpar  Profile assocation ");
                        exception.printStackTrace();
                        HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                        cIMInstance4 = cIMInstance;
                        cIMInstance4.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                        HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance4, cIMInstance, hscProviderSocket);
                    }
                    continue;
                }
                cIMProperty = (CIMProperty)vector3.elementAt(0);
                string4 = (String)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(1);
                string3 = (String)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("setting str and the userDefinedName is .." + string4 + " " + string3);
                }
                Trace.trace("apcshscD", "setting str is ..", string4);
                Trace.trace("apcshscD", "userDefinedName is ..", string3);
                cIMProperty = (CIMProperty)vector3.elementAt(2);
                unsignedInt87 = (UnsignedInt8)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the bootMode value is .." + unsignedInt87);
                }
                if (unsignedInt87 != null) {
                    Trace.trace("apcshscD", " the bootMode value is ..", unsignedInt87.toString());
                }
                cIMProperty = (CIMProperty)vector3.elementAt(3);
                unsignedInt86 = (UnsignedInt8)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(4);
                unsignedInt85 = (UnsignedInt8)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(5);
                unsignedInt84 = (UnsignedInt8)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(6);
                unsignedInt83 = (UnsignedInt32)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(7);
                unsignedInt82 = (UnsignedInt32)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the Drawer info..");
                }
                Trace.trace("apcshscD", "before the Drawer info..");
                cIMProperty = (CIMProperty)vector3.elementAt(8);
                object6 = (Vector)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after  the Drawer info.." + object6);
                }
                object5 = null;
                if (object6 == null) {
                    object5 = " No IO Drawer/slots  for this profile..";
                    object6 = new Vector();
                } else {
                    object5 = ((Vector)object6).toString();
                }
                Trace.trace("apcshscD", " after  the Drawer info..", object5);
                cIMProperty = (CIMProperty)vector3.elementAt(9);
                object4 = (Vector)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after  the slots info.." + object4);
                }
                if (object4 == null) {
                    object5 = " No IO Drawer/slots  for this profile..";
                    object4 = new Vector();
                } else {
                    object5 = ((Vector)object4).toString();
                }
                Trace.trace("apcshscD", "  after  the slots info..", object5);
                cIMProperty = (CIMProperty)vector3.elementAt(10);
                object3 = (Vector)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after  the requried  info.." + object3);
                }
                if (object3 == null) {
                    object5 = " No IO Drawer/slots  for this profile..";
                    object3 = new Vector();
                } else {
                    object5 = ((Vector)object3).toString();
                }
                Trace.trace("apcshscD", " after  the requried  info..", object5);
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("SettingID", new CIMValue((Object)string4));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the partion set in the lparProfile.." + string);
                }
                Trace.trace("apcshscD", " before the partion set in the lparProfile..", string);
                cIMInstance.setProperty("PartitionName", new CIMValue((Object)string));
                cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)string3));
                cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                cIMInstance.setProperty("BootMode", new CIMValue((Object)unsignedInt87));
                cIMInstance.setProperty("ServiceAuthority", new CIMValue((Object)unsignedInt86));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before assign of the Mem ..");
                }
                Trace.trace("apcshscD", " before assign of the Mem ..");
                cIMInstance.setProperty("DesiredMemoryMB", new CIMValue((Object)unsignedInt83));
                cIMInstance.setProperty("MinimumMemoryMB", new CIMValue((Object)unsignedInt82));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before assign of the cpus..");
                }
                Trace.trace("apcshscD", "before assign of the cpus..");
                cIMInstance.setProperty("DesiredCPUCount", new CIMValue((Object)unsignedInt85));
                cIMInstance.setProperty("MinimumCPUCount", new CIMValue((Object)unsignedInt84));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before assign of the IOSlots..");
                }
                Trace.trace("apcshscD", "before assign of the IOSlots..");
                cIMInstance.setProperty("IOSlots", new CIMValue((Vector)object4, new CIMDataType(21)));
                cIMInstance.setProperty("IODrawer", new CIMValue((Vector)object6, new CIMDataType(29)));
                cIMInstance.setProperty("IORequirement", new CIMValue((Vector)object3, new CIMDataType(29)));
                cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before creating of the lpar..");
                }
                Trace.trace("apcshscD", "before  creating of the lpar..");
                cIMObjectPath5 = CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMInstance);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after  creating of the lpar..");
                }
                Trace.trace("apcshscD", " after  creating of the lpar..");
                cIMObjectPath5 = cIMObjectPath3;
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the add key, lparProfile is.." + cIMObjectPath5);
                }
                Trace.trace("apcshscD", "  after the add key, lparProfile is..", cIMObjectPath5.toString());
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
                cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the create of asso partiton profile");
                }
                Trace.trace("apcshscD", " before the create of asso partiton profile");
                CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the create of asso partiton profile");
                }
                Trace.trace("apcshscD", " after the create of asso partiton profile");
                try {
                    cIMProperty = (CIMProperty)vector3.elementAt(11);
                    object2 = (Boolean)cIMProperty.getValue().getValue();
                    if (((Boolean)object2).booleanValue()) {
                        ComputerSystemProvUtils.addDefaultLparProfile(cIMOMHandle, cIMObjectPath, cIMObjectPath5);
                    }
                }
                catch (Exception exception) {
                    System.out.println(" Excp in Creation of Default Lpar  Profile assocation ");
                    exception.printStackTrace();
                    HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                    cIMInstance3 = cIMInstance;
                    cIMInstance3.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                    HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance3, cIMInstance, hscProviderSocket);
                }
                try {
                    cIMProperty = (CIMProperty)vector3.elementAt(12);
                    object2 = (Boolean)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" is activated !!!" + object2);
                    }
                    if (object2 != null) {
                        Trace.trace("apcshscD", " is activated !!!", ((Boolean)object2).toString());
                    }
                    if (!((Boolean)object2).booleanValue()) continue;
                    cIMInstance3 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
                    cIMClass2 = providerCIMOMHandle.getClass((CIMObjectPath)cIMInstance3, false);
                    unsignedInt8 = cIMClass2.newInstance();
                    unsignedInt8.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                    unsignedInt8.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
                    cIMObjectPath3 = new CIMObjectPath(unsignedInt8.getClassName(), unsignedInt8.getKeyValuePairs());
                    cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before activate asso creation..");
                    }
                    Trace.trace("apcshscD", " before activate asso creation..");
                    CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, (CIMInstance)unsignedInt8);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after activate asso creation..");
                    }
                    Trace.trace("apcshscD", "  after activate asso creation..");
                }
                catch (Exception exception) {
                    System.out.println(" Excp in Creation of activated Lpar  Profile assocation ");
                    exception.printStackTrace();
                    HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                    cIMInstance3 = cIMInstance;
                    cIMInstance3.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                    HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance3, cIMInstance, hscProviderSocket);
                }
            }
        }
    }

    public static CIMInstance addPartitions(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, NVRAM nVRAM, int n, boolean bl, HscProviderSocket hscProviderSocket, int n2, int n3) throws CIMException {
        Object object;
        CIMInstance cIMInstance;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance2 = null;
        Hashtable hashtable = null;
        int n4 = -1;
        String string = null;
        Integer n5 = null;
        Vector vector = new Vector();
        String[] stringArray = new String[1];
        Object var17_17 = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance3 = null;
        CIMObjectPath cIMObjectPath3 = null;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        short s = -1;
        int n9 = -1;
        int n10 = -1;
        String string2 = null;
        Vector vector2 = cIMObjectPath.getKeys();
        if (vector2 != null) {
            cIMInstance = vector2.elements();
            while (cIMInstance.hasMoreElements()) {
                object = (CIMProperty)cIMInstance.nextElement();
                if (!"Name".equalsIgnoreCase(object.getName())) continue;
                string2 = (String)object.getValue().getValue();
                break;
            }
        }
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("the cec Name in addDrawerAndSlots is" + string2);
        }
        Trace.trace("apcshscD", "the cec Name in addDrawerAndSlots is", string2);
        cIMObjectPath2 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
        stringArray = new String[]{Integer.toHexString(n)};
        cIMInstance = null;
        object = nVRAM.getLPARInfo(hscProviderSocket, n);
        if (object != null) {
            String string3;
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println("partition Info: " + ((Vector)object).toString());
            }
            Trace.trace("aplphscD", "partition information: " + ((Vector)object).toString());
            String string4 = null;
            String string5 = null;
            UnsignedInt8 unsignedInt8 = new UnsignedInt8(1);
            UnsignedInt8 unsignedInt82 = new UnsignedInt8(1);
            string = (String)((Vector)object).elementAt(0);
            CIMInstance cIMInstance4 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath, new CIMClass(cIMObjectPath.getObjectName()), false);
            String string6 = (String)cIMInstance4.getProperty("CSPVersion").getValue().getValue();
            int n11 = VersionComparator.CSPVersionValue(string6);
            if ((float)n11 >= 2000.0f) {
                string3 = (String)((Vector)object).elementAt(1);
                if (string3 != null) {
                    string4 = string3.substring(0, string3.length() - 1);
                    string5 = string3.substring(string3.length() - 1);
                }
                unsignedInt8 = new UnsignedInt8(((Short)((Vector)object).elementAt(2)).shortValue());
                n10 = unsignedInt8.shortValue();
                if (n2 == 1 && n3 == 255) {
                    hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_TYPE", stringArray, hscProviderSocket);
                    n5 = (Integer)hashtable.get("TYPE_VALUE");
                    n8 = n5.shortValue();
                    unsignedInt82 = new UnsignedInt8(((Integer)hashtable.get("RMO_TYPE")).shortValue());
                    System.out.println("Runtime RMO type: " + unsignedInt82);
                    if (n8 != n10) {
                        System.out.println("Putting CEC into Recovery state...");
                        CIMInstance cIMInstance5 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath, cIMOMHandle.getClass(cIMObjectPath, false), false);
                        CIMInstance cIMInstance6 = cIMInstance5.filterProperties(null, true, true);
                        cIMInstance6.setProperty("State", new CIMValue((Object)new UnsignedInt8(251)));
                        CimomWrapper.setInstance(cIMOMHandle, cIMObjectPath, cIMInstance6);
                        try {
                            AsynchEventManager.sendIndication(4, cIMInstance6, cIMInstance5);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                        }
                        return cIMInstance2;
                    }
                }
                Trace.trace("aplphscD", "Phys. loc. code: " + string4);
                Trace.trace("aplphscD", "affinity ID: " + string5);
                Trace.trace("aplphscD", "partition type: " + unsignedInt8);
                Trace.trace("aplphscD", "Runtime RMO type: " + unsignedInt82);
            }
            if (!string.equalsIgnoreCase("")) {
                System.out.println(" inside the lpar name is .." + string);
                s = (short)n;
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                cIMInstance2 = cIMClass.newInstance();
                string3 = null;
                string3 = s > 9 ? "0" + s : "00" + s;
                string3 = string3 + "*" + string2;
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the pName Namr is .." + string3);
                }
                Trace.trace("apcshscD", " the pName Namr is ..", string3);
                cIMInstance2.setProperty("Name", new CIMValue((Object)string3));
                cIMInstance2.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                cIMInstance2.setProperty("UserDefinedName", new CIMValue((Object)string));
                cIMInstance2.setProperty("PhysLocCode", new CIMValue((Object)string4));
                cIMInstance2.setProperty("AffinityGroupID", new CIMValue((Object)string5));
                cIMInstance2.setProperty("PartitionType", new CIMValue((Object)unsignedInt8));
                cIMInstance2.setProperty("RuntimeRMOSize", new CIMValue((Object)unsignedInt82));
                if (n2 == 1 && n3 == 255) {
                    hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_STATE", stringArray, hscProviderSocket);
                    n5 = (Integer)hashtable.get("LPAR_STATE");
                    n7 = n5.shortValue();
                    if (((Vector)object).size() > 1 && (n7 == 1 || n7 == 12)) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_PARTITION_MODE", null, hscProviderSocket);
                        n5 = (Integer)hashtable.get("MODE");
                        n9 = n5.shortValue();
                        System.out.println("Partition mode: " + n9);
                        if (n9 == 1 && n10 != 1) {
                            n7 = 252;
                            System.out.println("PARTITION NOT AVAILABLE!!");
                            System.out.println("LPAR STATE: " + n7);
                        }
                        if (n9 == 3 && n10 != 3) {
                            n7 = 252;
                            System.out.println("PARTITION NOT AVAILABLE!!");
                            System.out.println("LPAR STATE: " + n7);
                        }
                        if (n9 == 2 && n10 != 2) {
                            n7 = 252;
                            System.out.println("PARTITION NOT AVAILABLE!!");
                            System.out.println("LPAR STATE: " + n7);
                        }
                    }
                    if ((n5 = (Integer)(hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", stringArray, hscProviderSocket)).get("DEFINITION_STATE")).shortValue() == 4 && n2 != 12) {
                        cIMInstance2.setProperty("PartitionState", new CIMValue((Object)new UnsignedInt8(251)));
                        return cIMInstance2;
                    }
                } else {
                    n7 = 252;
                }
                System.out.println(" the lparState is ..." + n7);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the lparState is ..." + n7);
                }
                Trace.trace("apcshscD", " the lparState is ..." + n7);
                cIMInstance2.setProperty("PartitionState", new CIMValue((Object)new UnsignedInt8((short)n7)));
                if (n2 == 1 && n3 == 255) {
                    try {
                        hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_BOOT_ERROR_VALUES", stringArray, hscProviderSocket);
                        n5 = (Integer)hashtable.get("BOOT_ERROR");
                        cIMInstance2.setProperty("BootErrorValue", new CIMValue((Object)new UnsignedInt8(n5.shortValue())));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                cIMInstance2.setProperty("Editable", CIMValue.TRUE);
                if (bl) {
                    ComputerSystemProvUtils.closeVTTYTerminal(hscProviderSocket, stringArray, s);
                }
                cIMObjectPath3 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                CIMObjectPath cIMObjectPath4 = CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMInstance2);
                cIMObjectPath2 = cIMObjectPath3;
                cIMObjectPath4 = new CIMObjectPath("IBMHSC_Partition", cIMInstance2.getKeyValuePairs());
                cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the lpar obj is .." + cIMObjectPath4);
                }
                Trace.trace("apcshscD", "the lpar obj is ..", cIMObjectPath4.toString());
                cIMInstance = cIMInstance2;
                CIMObjectPath cIMObjectPath5 = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath5, false);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the get Class..");
                }
                Trace.trace("apcshscD", " after the get Class..");
                cIMInstance3 = cIMClass.newInstance();
                cIMInstance3.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the set of op..");
                }
                Trace.trace("apcshscD", " after the set of op..");
                cIMInstance3.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath4));
                cIMObjectPath3 = new CIMObjectPath(cIMInstance3.getClassName(), cIMInstance3.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the CompSysPartition");
                }
                Trace.trace("apcshscD", "  before the CompSysPartition");
                CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMInstance3);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the CompSysPartition");
                }
                Trace.trace("apcshscD", "   after the CompSysPartition");
            }
        }
        return cIMInstance2;
    }

    public static void addSystemProfiles(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, Vector vector, boolean bl) throws CIMException {
        CIMProperty cIMProperty;
        Vector vector2;
        Object object;
        CIMProperty cIMProperty2;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        Vector vector3 = cIMObjectPath.getKeys();
        String string = null;
        if (vector3 != null) {
            cIMProperty2 = vector3.elements();
            while (cIMProperty2.hasMoreElements()) {
                object = (CIMProperty)cIMProperty2.nextElement();
                if (!"Name".equalsIgnoreCase(object.getName())) continue;
                string = (String)object.getValue().getValue();
                break;
            }
        }
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("the cec Name in addSystemProfiles is" + string);
        }
        Trace.trace("apcshscD", "the cec Name in addSystemProfiles is", string);
        cIMProperty2 = (CIMProperty)vector.elementAt(0);
        object = (String)cIMProperty2.getValue().getValue();
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" inside of the loop..2" + (String)object);
        }
        Trace.trace("apcshscD", " inside of the loop..2", object);
        CIMProperty cIMProperty3 = (CIMProperty)vector.elementAt(1);
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" inside of the loop..3");
        }
        Trace.trace("apcshscD", " inside of the loop..3");
        String string2 = (String)cIMProperty3.getValue().getValue();
        string2 = string2.trim();
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" inside of the loop..3.5" + string2);
        }
        Trace.trace("apcshscD", " inside of the loop..3.5", string2);
        CIMProperty cIMProperty4 = (CIMProperty)vector.elementAt(2);
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" inside of the loop..4");
        }
        Trace.trace("apcshscD", " inside of the loop..4");
        Vector vector4 = (Vector)cIMProperty4.getValue().getValue();
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" the lparProfileVec .." + vector4);
        }
        if (vector4 != null) {
            Trace.trace("apcshscD", "  the lparProfileVec ..", vector4.toString());
        }
        if ((vector2 = (Vector)(cIMProperty = (CIMProperty)vector.elementAt(3)).getValue().getValue()) != null) {
            Trace.trace("apcshscD", "the Partition ids .", cIMProperty.toString());
        }
        CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_SystemProfile", "root/ibmhscV3_2");
        cIMClass = providerCIMOMHandle.getClass(cIMObjectPath3, false);
        cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("Name", new CIMValue(object));
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" ck1..");
        }
        cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)string2));
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" ck2..");
        }
        cIMInstance.setProperty("ComputerSystemName", new CIMValue((Object)string));
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" ck3..");
        }
        cIMInstance.setProperty("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" before the creation of the Sys profile");
        }
        Trace.trace("apcshscD", " before the creation of the Sys profile");
        cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
        cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
        CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath2, cIMInstance);
        CIMObjectPath cIMObjectPath4 = cIMObjectPath2;
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" after the creation of the Sys profile" + cIMObjectPath4);
        }
        Trace.trace("apcshscD", " after the creation of the Sys profile", cIMObjectPath4.toString());
        CIMObjectPath cIMObjectPath5 = new CIMObjectPath("IBMHSC_CompSysProfile", "root/ibmhscV3_2");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" 12");
        }
        cIMClass = providerCIMOMHandle.getClass(cIMObjectPath5, false);
        CIMInstance cIMInstance2 = cIMClass.newInstance();
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" 13");
        }
        cIMInstance2.setProperty("Element", new CIMValue((Object)cIMObjectPath));
        cIMInstance2.setProperty("Configuration", new CIMValue((Object)cIMObjectPath4));
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" 14");
        }
        cIMObjectPath2 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
        cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" before the compSysProfile asso cre..");
        }
        Trace.trace("apcshscD", " before the compSysProfile asso cre..");
        CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath2, cIMInstance2);
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" after the compSysProfile cre..");
        }
        Trace.trace("apcshscD", " after the compSysProfile asso cre..");
        if (vector4 != null && bl) {
            int n = 0;
            while (n < vector4.size()) {
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" inside of the for loop..");
                }
                Trace.trace("apcshscD", " inside of the for loop..");
                CIMObjectPath cIMObjectPath6 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
                String string3 = (String)vector4.elementAt(n);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" cck1 .." + string3);
                }
                Trace.trace("apcshscD", " cck1 ..", string3);
                UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector2.elementAt(n);
                String string4 = null;
                short s = 9;
                string4 = unsignedInt8.shortValue() > s ? "0" + unsignedInt8 + "*" + string : "00" + unsignedInt8 + "*" + string;
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the partition name is create sys .." + string4);
                }
                Trace.trace("apcshscD", "  the partition name is create sys ..", string4);
                cIMObjectPath6.addKey("SettingID", new CIMValue((Object)string3));
                cIMObjectPath6.addKey("PartitionName", new CIMValue((Object)string4));
                cIMObjectPath6.addKey("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                cIMObjectPath6.setNameSpace("root/ibmhscV3_2");
                CIMObjectPath cIMObjectPath7 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath7, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("Context", new CIMValue((Object)cIMObjectPath4));
                cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath6));
                Integer n2 = new Integer(n);
                cIMInstance.setProperty("ActivateOrder", new CIMValue((Object)new UnsignedInt8(n2.shortValue())));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the InsysProfile creation **********" + cIMInstance);
                }
                Trace.trace("apcshscD", " before the InsysProfile creation **********", cIMInstance.toString());
                cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath2, cIMInstance);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the InsysProfile creation");
                }
                Trace.trace("apcshscD", "  after the InsysProfile creation");
                ++n;
            }
        }
    }

    private static int getLparIdFromObjPath(CIMObjectPath cIMObjectPath) {
        CIMProperty cIMProperty = ComputerSystemProvUtils.getNameProperty(cIMObjectPath.getKeys());
        String string = (String)cIMProperty.getValue().getValue();
        string = string.substring(0, 3);
        return Integer.parseInt(string);
    }

    private static void updateSMAAssociations(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, HscProviderSocket hscProviderSocket, String string) throws CIMException {
        int n = ComputerSystemProvUtils.getLparIdFromObjPath(cIMObjectPath);
        ComputerSystemProvUtils.removeSMAAssoc(cIMOMHandle, cIMObjectPath);
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_NUMBER_OF_SMA_ADAPTERS", null, hscProviderSocket, string);
        Vector vector = (Vector)hashtable.get("DEV_LIST");
        int n2 = 0;
        while (n2 < vector.size()) {
            String string2 = ((Long)vector.elementAt(n2)).toString();
            ComputerSystemProvUtils.updSMAAssoForOneAdapter(cIMOMHandle, string2, n, cIMObjectPath, hscProviderSocket, string);
            ++n2;
        }
    }

    private static void removeSMAAssoc(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath) throws CIMException {
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_AllocatedSNIAdapter", "root/ibmhscV3_2");
        Vector vector = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null);
        if (vector == null || vector.isEmpty()) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
            CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
        }
    }

    private static void updSMAAssoForOneAdapter(CIMOMHandle cIMOMHandle, String string, int n, CIMObjectPath cIMObjectPath, HscProviderSocket hscProviderSocket, String string2) throws CIMException {
        Integer n2;
        Hashtable hashtable;
        Hashtable hashtable2 = HscProviderUtils.doCSPCommand("GET_SMA_ADAPTER_INFO", new String[]{string}, hscProviderSocket, string2);
        Vector vector = (Vector)hashtable2.get("LPAR_INFO_LIST");
        if (vector == null || vector.size() == 0) {
            return;
        }
        Hashtable hashtable3 = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < vector.size()) {
            hashtable = (Hashtable)vector.elementAt(n4);
            n2 = (Integer)hashtable.get("LPAR_ID");
            Integer n5 = (Integer)hashtable.get("NUM_WINS_USING");
            n3 = n5;
            if (n2 == n && n3 > 0) {
                hashtable3 = hashtable;
                break;
            }
            ++n4;
        }
        if (hashtable3 == null) {
            return;
        }
        hashtable = new CIMObjectPath("IBMHSC_SNIAdapter", "root/ibmhscV3_2");
        hashtable.addKey(DEVICE_ID, new CIMValue((Object)string));
        hashtable.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        hashtable.addKey("SystemName", new CIMValue((Object)ComputerSystemProvUtils.getCecName(cIMObjectPath)));
        hashtable.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_SNIAdapter"));
        vector.remove(hashtable3);
        n2 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
        n2.setKeys((Vector)cIMObjectPath.getKeys().clone());
        ComputerSystemProvUtils.updateSMAAssoForStealPars(cIMOMHandle, vector, (CIMObjectPath)hashtable, (CIMObjectPath)n2);
        ComputerSystemProvUtils.createSMAAsso(cIMOMHandle, cIMObjectPath, (CIMObjectPath)hashtable, n3);
    }

    private static void updateSMAAssoForStealPars(CIMOMHandle cIMOMHandle, Vector vector, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        if (vector.size() == 0) {
            return;
        }
        Vector vector2 = cIMObjectPath2.getKeys();
        CIMProperty cIMProperty = ComputerSystemProvUtils.getNameProperty(vector2);
        String string = ComputerSystemProvUtils.getCecName(cIMProperty);
        int n = 0;
        while (n < vector.size()) {
            Hashtable hashtable = (Hashtable)vector.elementAt(n);
            Integer n2 = (Integer)hashtable.get("NUM_WINS_USING");
            int n3 = n2;
            if (n3 == 0) {
                Integer n4 = (Integer)hashtable.get("LPAR_ID");
                ComputerSystemProvUtils.replaceParName(cIMObjectPath2, vector2, cIMProperty, string, n4);
                CIMObjectPath cIMObjectPath3 = ComputerSystemProvUtils.getSMAAssoObjPath(cIMOMHandle, cIMObjectPath2, cIMObjectPath);
                try {
                    CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    private static String getCecName(CIMObjectPath cIMObjectPath) {
        CIMProperty cIMProperty = ComputerSystemProvUtils.getNameProperty(cIMObjectPath.getKeys());
        String string = (String)cIMProperty.getValue().getValue();
        return string.substring(4);
    }

    private static String getCecName(CIMProperty cIMProperty) {
        String string = (String)cIMProperty.getValue().getValue();
        return string.substring(3);
    }

    private static CIMProperty getNameProperty(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            if (cIMProperty.getName().equalsIgnoreCase("Name")) {
                return cIMProperty;
            }
            ++n;
        }
        return null;
    }

    private static void replaceParName(CIMObjectPath cIMObjectPath, Vector vector, CIMProperty cIMProperty, String string, Integer n) {
        String string2 = n.toString();
        if (string2.length() < 2) {
            string2 = "00" + string2;
        } else if (string2.length() < 3) {
            string2 = "0" + string2;
        }
        string2 = string2 + string;
        cIMProperty.setValue(new CIMValue((Object)string2));
        cIMObjectPath.setKeys(vector);
    }

    private static void createSMAAsso(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, int n) throws CIMException {
        CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_AllocatedSNIAdapter", "root/ibmhscV3_2");
        CIMInstance cIMInstance = cIMOMHandle.getClass(cIMObjectPath3, false).newInstance();
        cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
        cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
        cIMInstance.setProperty("NumOfWindows", new CIMValue((Object)new UnsignedInt16(n)));
        cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
        cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
        CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance);
    }

    private static CIMObjectPath getSMAAssoObjPath(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_AllocatedSNIAdapter", "root/ibmhscV3_2");
        CIMInstance cIMInstance = cIMOMHandle.getClass(cIMObjectPath3, false).newInstance();
        cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
        cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
        cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
        cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
        return cIMObjectPath3;
    }

    public static void addAllocateLparResources(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, Vector vector, HscProviderSocket hscProviderSocket) throws CIMException {
        Serializable serializable;
        int n;
        Object object;
        Integer n2;
        Enumeration enumeration;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        Hashtable hashtable = null;
        Vector vector2 = null;
        Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
        Hashtable<CIMObjectPath, Short> hashtable3 = new Hashtable<CIMObjectPath, Short>();
        String[] stringArray = new String[1];
        Integer n3 = null;
        CIMInstance cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, new CIMClass(cIMObjectPath.getObjectName()), false);
        String string = (String)cIMInstance3.getProperty("CSPVersion").getValue().getValue();
        int n4 = ((UnsignedInt16)cIMInstance3.getProperty("RuntimeCapability").getValue().getValue()).intValue();
        boolean bl = (float)VersionComparator.CSPVersionValue(string) > 3000.0f && (n4 & 0x20) != 0;
        System.out.println("smaCapable: " + bl);
        Vector vector3 = cIMObjectPath.getKeys();
        String string2 = null;
        if (vector3 != null) {
            enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!"Name".equalsIgnoreCase(cIMProperty.getName())) continue;
                string2 = (String)cIMProperty.getValue().getValue();
                break;
            }
        }
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("the cec Name in addAllocatedLparResources is" + string2);
        }
        Trace.trace("apcshscD", "the cec Name in addAllocatedLparResources is", string2);
        hashtable = HscProviderUtils.doCSPCommand("GET_ALL_PROC_LPAR_ASSIGN_VALUE", null, hscProviderSocket);
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" the response after the GET all   proc LPAR assign value.." + hashtable);
        }
        if (hashtable != null) {
            Trace.trace("apcshscD", " the response after the GET all & proc LPAR assign value..", hashtable.toString());
        }
        vector2 = (Vector)hashtable.get("ALL_PROC_ASSIGNMENT");
        enumeration = vector2.elements();
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            n2 = (Integer)enumeration.nextElement();
            Integer n6 = new Integer(n5);
            hashtable2.put(n6, n2);
            ++n5;
        }
        n2 = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
        hashtable = HscProviderUtils.doCSPCommand("GET_NUM_IO_DRAWERS", null, hscProviderSocket);
        n3 = (Integer)hashtable.get("NUM_IO_DRAWERS");
        int n7 = n3.shortValue();
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" The num of IO drawer's allocated is  ..." + n7);
        }
        Trace.trace("apcshscD", " The num of IO drawer's allocated is  ..." + n7);
        String[] stringArray2 = (String[])hashtable.get("DRAWER_IDS");
        int n8 = 0;
        while (n8 < n7) {
            stringArray = new String[]{stringArray2[n8]};
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" Drawer id in alloc .." + stringArray[0]);
            }
            Trace.trace("apcshscD", " Drawer id in alloc ..", stringArray[0]);
            hashtable = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", stringArray, hscProviderSocket);
            n3 = (Integer)hashtable.get("NUM_SLOTS");
            short s = n3.shortValue();
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println("the number of slots .." + s);
            }
            Trace.trace("apcshscD", " the number of slots .." + s);
            object = (Hashtable)hashtable.get("SLOT_INFORMATION");
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println("slots hashtable in alloc.." + object);
            }
            Trace.trace("apcshscD", " slots hashtable in alloc.." + object);
            n = 0;
            while (n < s) {
                serializable = (Hashtable)((Hashtable)object).get(new Integer(n));
                n3 = (Integer)((Hashtable)serializable).get("SLOT_NO");
                short s2 = n3.shortValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the grp key is ." + s2);
                }
                Trace.trace("apcshscD", "  the grp key is ." + s2);
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
                cIMObjectPath4.addKey(IO_DRAWER_ID, new CIMValue((Object)stringArray[0]));
                cIMObjectPath4.addKey(SLOT_ID, new CIMValue((Object)new UnsignedInt8(s2)));
                cIMObjectPath4.addKey("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
                cIMObjectPath4.addKey("IODrawerSystemName", new CIMValue((Object)string2));
                cIMObjectPath4.addKey("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                n3 = (Integer)((Hashtable)serializable).get("LPAR_ID");
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the pci slot path is  ." + cIMObjectPath4);
                }
                Trace.trace("apcshscD", " the pci slot path is  .", cIMObjectPath4.toString());
                hashtable3.put(cIMObjectPath4, new Short(n3.shortValue()));
                ++n;
            }
            ++n8;
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            CIMObjectPath cIMObjectPath5;
            Object object2;
            Object object3;
            cIMInstance2 = (CIMInstance)enumeration2.nextElement();
            cIMObjectPath3 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            if (bl) {
                ComputerSystemProvUtils.updateSMAAssociations(cIMOMHandle, cIMObjectPath3, hscProviderSocket, string);
            }
            try {
                HscProviderUtils.deletePartionResources(cIMObjectPath3, (CIMOMHandle)providerCIMOMHandle);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            }
            object = (String)cIMInstance2.getProperty("Name").getValue().getValue();
            n = Short.parseShort(((String)object).substring(0, 3));
            stringArray = new String[]{Integer.toHexString(n)};
            hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", stringArray, hscProviderSocket, string);
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" the response after the Get lpar memory Res..." + hashtable);
            }
            Trace.trace("apcshscD", " the response after the Get lpar memory Res...", hashtable.toString());
            serializable = (Long)hashtable.get("TOT_ALLOC_MEMORY");
            long l = (Long)serializable;
            serializable = (Long)hashtable.get("PAGE_TABLE_ALLOC_MEMORY");
            long l2 = (Long)serializable;
            cIMInstance2.setProperty("AllocatedMemory", new CIMValue((Object)new UnsignedInt32(l)));
            cIMInstance2.setProperty("PageTableMemory", new CIMValue((Object)new UnsignedInt32(l2)));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.setInstance(cIMOMHandle, cIMObjectPath2, cIMInstance2);
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println(" after set lpar...");
            }
            Trace.trace("apcshscD", " after set lpar...");
            System.out.println(" the CPU HASH is ..." + hashtable2);
            Trace.trace("apcshscD", " the CPU HASH is ...", hashtable2.toString());
            Enumeration enumeration3 = hashtable2.keys();
            int n9 = 0;
            while (enumeration3.hasMoreElements()) {
                object3 = (Integer)enumeration3.nextElement();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the next Element .." + object3);
                }
                Trace.trace("apcshscD", "  after the next Element ..", ((Integer)object3).toString());
                object2 = (Integer)hashtable2.get(object3);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the lparID, cpuLparID is .." + n + " " + object2);
                }
                Trace.trace("apcshscD", "  the lparID" + n);
                Trace.trace("apcshscD", "  cpuLparID is ..", ((Integer)object2).toString());
                if (n == ((Integer)object2).shortValue()) {
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" CPU ID and lpar ID Matched");
                    }
                    Trace.trace("apcshscD", " CPU ID and lpar ID Matched");
                    stringArray = new String[]{Integer.toHexString((Integer)object3)};
                    hashtable = HscProviderUtils.doCSPCommand("GET_PROC_STATUS", stringArray, hscProviderSocket);
                    n3 = (Integer)hashtable.get("PROC_STATUS");
                    short s = n3.shortValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" the process status is .." + s);
                    }
                    Trace.trace("apcshscD", "  the process status is .." + s);
                    if (s != 0 && s != 16) {
                        cIMObjectPath5 = new CIMObjectPath("IBMHSC_Processor", "root/ibmhscV3_2");
                        cIMObjectPath5.addKey(DEVICE_ID, new CIMValue((Object)new UnsignedInt8(((Integer)object3).shortValue())));
                        cIMObjectPath5.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Processor"));
                        cIMObjectPath5.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                        cIMObjectPath5.addKey("SystemName", new CIMValue((Object)string2));
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" the process obj is ." + cIMObjectPath5);
                        }
                        Trace.trace("apcshscD", " the process obj is .", cIMObjectPath5.toString());
                        CIMObjectPath cIMObjectPath6 = new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2");
                        cIMClass = providerCIMOMHandle.getClass(cIMObjectPath6, false);
                        cIMInstance = cIMClass.newInstance();
                        cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath3));
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" after setting the partitionObj..");
                        }
                        Trace.trace("apcshscD", "  after setting the partitionObj..");
                        cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath5));
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" after setting the processor..");
                        }
                        Trace.trace("apcshscD", "  after setting the processor..");
                        cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                        cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                        CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, cIMInstance);
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" after create alloac processor..");
                        }
                        Trace.trace("apcshscD", "  after create alloac processor..");
                    }
                }
                ++n9;
            }
            object3 = hashtable3.keys();
            while (object3.hasMoreElements()) {
                object2 = (CIMObjectPath)object3.nextElement();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the obj path of slot Group when partition is running is .." + object2);
                }
                Trace.trace("apcshscD", "  the obj path of slot Group when partition is running is ..", object2.toString());
                Short s = (Short)hashtable3.get(object2);
                if (n != s) continue;
                cIMObjectPath5 = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath5, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath3));
                cIMInstance.setProperty("PartComponent", new CIMValue(object2));
                cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, cIMInstance);
            }
        }
    }

    public static void allocateProcessor(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, HscProviderSocket hscProviderSocket) throws CIMException {
        CIMProperty cIMProperty;
        UnsignedInt8 unsignedInt8;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath3 = null;
        Hashtable hashtable = null;
        Vector vector = cIMObjectPath.getKeys();
        String string = null;
        if (vector != null) {
            unsignedInt8 = vector.elements();
            while (unsignedInt8.hasMoreElements()) {
                cIMProperty = (CIMProperty)unsignedInt8.nextElement();
                if (!"Name".equalsIgnoreCase(cIMProperty.getName())) continue;
                string = (String)cIMProperty.getValue().getValue();
                break;
            }
        }
        vector = cIMObjectPath2.getKeys();
        unsignedInt8 = null;
        if (vector != null) {
            cIMProperty = vector.elements();
            while (cIMProperty.hasMoreElements()) {
                CIMProperty cIMProperty2 = (CIMProperty)cIMProperty.nextElement();
                if (!DEVICE_ID.equalsIgnoreCase(cIMProperty2.getName())) continue;
                unsignedInt8 = (UnsignedInt8)cIMProperty2.getValue().getValue();
                break;
            }
        }
        boolean bl = true;
        int n = 0;
        try {
            hashtable = HscProviderUtils.doCSPCommand("GET_PROC_LPAR_ASSIGN_VALUE", new String[]{Integer.toHexString(unsignedInt8.intValue())}, hscProviderSocket);
            Integer n2 = (Integer)hashtable.get("LPAR_ID");
            n = n2;
            if (n != 0) {
                String string2 = null;
                string2 = n > 9 ? "0" + n : "00" + n;
                string2 = string2 + "*" + string;
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
                cIMObjectPath4.addKey("Name", new CIMValue((Object)string2));
                cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the partition  obj is ." + cIMObjectPath4);
                }
                Trace.trace("apcshscD", " the partition  obj is .", cIMObjectPath4.toString());
                CIMObjectPath cIMObjectPath5 = new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath5, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath4));
                cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
                cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMInstance);
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throwable.printStackTrace();
        }
    }

    public static void allocateDrawer(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, String string, HscProviderSocket hscProviderSocket) throws CIMException {
        Object object;
        String[] stringArray;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        Hashtable hashtable = null;
        Vector vector = cIMObjectPath.getKeys();
        String string2 = null;
        if (vector != null) {
            stringArray = vector.elements();
            while (stringArray.hasMoreElements()) {
                object = (CIMProperty)stringArray.nextElement();
                if (!"Name".equalsIgnoreCase(object.getName())) continue;
                string2 = (String)object.getValue().getValue();
                break;
            }
        }
        stringArray = new String[]{string};
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" Drawer id in alloc .." + stringArray[0]);
        }
        Trace.trace("apcshscD", " Drawer id in alloc ..", stringArray[0]);
        hashtable = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", stringArray, hscProviderSocket);
        object = (Integer)hashtable.get("NUM_SLOTS");
        int n = ((Integer)object).shortValue();
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("the number of slots .." + n);
        }
        Trace.trace("apcshscD", "the number of slots .." + n);
        Hashtable hashtable2 = (Hashtable)hashtable.get("SLOT_INFORMATION");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("slots hashtable in alloc.." + hashtable2);
        }
        Trace.trace("apcshscD", "slots hashtable in alloc..", hashtable2.toString());
        int n2 = 0;
        while (n2 < n) {
            Hashtable hashtable3 = (Hashtable)hashtable2.get(new Integer(n2));
            object = (Integer)hashtable3.get("SLOT_NO");
            short s = ((Integer)object).shortValue();
            object = (Integer)hashtable3.get("LPAR_ID");
            int n3 = (Integer)object;
            if (n3 != 0) {
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
                cIMObjectPath3.addKey(IO_DRAWER_ID, new CIMValue((Object)string));
                cIMObjectPath3.addKey(SLOT_ID, new CIMValue((Object)new UnsignedInt8(s)));
                cIMObjectPath3.addKey("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
                cIMObjectPath3.addKey("IODrawerSystemName", new CIMValue((Object)string2));
                cIMObjectPath3.addKey("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                String string3 = null;
                string3 = n3 > 9 ? "0" + n3 : "00" + n3;
                string3 = string3 + "*" + string2;
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
                cIMObjectPath4.addKey("Name", new CIMValue((Object)string3));
                cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the partition  obj is ." + cIMObjectPath4);
                }
                Trace.trace("apcshscD", " the partition  obj is .", cIMObjectPath4.toString());
                CIMObjectPath cIMObjectPath5 = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath5, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath4));
                cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath3));
                cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                System.out.println(" before the all slot cr..");
                CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, cIMInstance);
                System.out.println(" after the all slot cr..");
            }
            ++n2;
        }
    }

    public static String getHMCVersion(CIMOMHandle cIMOMHandle) throws CIMException {
        String string;
        HSCVPD hSCVPD = null;
        String string2 = null;
        Trace.trace("apcshscT", "->getHMCVersion");
        try {
            hSCVPD = new HSCVPD();
            Trace.trace("apcshscF", "_vpd = " + hSCVPD);
            String string3 = null;
            String string4 = null;
            if (hSCVPD.isVPDPresent()) {
                string3 = hSCVPD.getHSCModel();
                Trace.trace("apcshscF", "modelData = " + string3);
                string4 = hSCVPD.getHSCSerialNumber();
                Trace.trace("apcshscF", "serialNumData = " + string4);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("********************>>> ");
                    System.out.println("modelData = " + string3);
                    System.out.println("serialNumData = " + string4);
                    System.out.println("<<<******************** ");
                }
            } else {
                throw new HSCCIMException("1781");
            }
            String string5 = string3.concat("*").concat(string4);
            if (string5.length() > 31) {
                System.out.println("console name bef trucate " + string5);
                int n = string5.length() - 31;
                string5 = string5.substring(n);
                System.out.println("console name aft trucate " + string5);
            }
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Console", "root/ibmhscV3_2");
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Console"));
            cIMObjectPath.addKey("Name", new CIMValue((Object)string5));
            CIMInstance cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Console"), false);
            if (cIMInstance != null) {
                string2 = (String)cIMInstance.getProperty("HMCVersion").getValue().getValue();
            }
            string = string2;
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("01F9");
                }
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                Object var10_12 = null;
                Trace.trace("apcshscT", "<-getHMCVersion");
                throw throwable2;
            }
        }
        Trace.trace("apcshscT", "<-getHMCVersion");
        return string;
    }

    public static String checkCSPVersionSpoofing(int n, String string, HscProviderSocket hscProviderSocket, CIMOMHandle cIMOMHandle) throws CIMException {
        Hashtable hashtable = null;
        Trace.trace("apcshscT", "-> checkCSPVersionSpoofing");
        Trace.trace("apcshscF", "nodeCapability = " + n);
        Trace.trace("apcshscF", "currentCSPVersion = " + string);
        if ((n & 0x80) != 0) {
            Trace.trace("apcshscD", "CSP supports multiple HMC-CSP command interfaces");
            String string2 = ComputerSystemProvUtils.getHMCVersion(cIMOMHandle);
            Trace.trace("apcshscD", "HMC Version = " + string2);
            hashtable = HscProviderUtils.doCSPCommand("GET_VERSIONS_SUPPORTED", null, hscProviderSocket, string);
            Vector vector = (Vector)hashtable.get("VERSION_LIST");
            Hashtable hashtable2 = null;
            String string3 = null;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                hashtable2 = (Hashtable)enumeration.nextElement();
                string3 = (String)hashtable2.get("VERSION");
                Trace.trace("apcshscD", "CSP supports version " + string3);
                if (!VersionComparator.isCompatible(string2, string3) || VersionComparator.CSPVersionValue(string3) <= VersionComparator.CSPVersionValue(string)) continue;
                Trace.trace("apcshscD", "Setting HMC-CSP Interface Version to " + string3);
                HscProviderUtils.doCSPCommand("SET_INTERFACE_VERSION_LEVEL", new String[]{Integer.toHexString(((Byte)hashtable2.get("FORMAT_TYPE")).intValue()), string3}, hscProviderSocket, string);
                string = string3;
            }
        }
        Trace.trace("apcshscF", "returned currentCSPVersion = " + string);
        Trace.trace("apcshscT", "<- checkCSPVersionSpoofing");
        return string;
    }

    public static CIMObjectPath createCECInst(CIMOMHandle cIMOMHandle, HscProviderSocket hscProviderSocket, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        CIMObjectPath cIMObjectPath3 = null;
        Trace.trace("apcshscT", "->createCECInst");
        try {
            String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)string));
            cIMObjectPath3 = CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath, cIMInstance);
            cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            if (GlobalConfig.debugLevel((int)1) > 0) {
                System.out.println("The Computer System op = " + cIMObjectPath3);
            }
            cIMObjectPath2 = cIMObjectPath3;
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("01F9");
                }
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                Object var8_9 = null;
                Trace.trace("apcshscT", "<-createCECInst");
                throw throwable2;
            }
        }
        Trace.trace("apcshscT", "<-createCECInst");
        return cIMObjectPath2;
    }

    private static Hashtable _getProcStatus(HscProviderSocket hscProviderSocket, String[] stringArray) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        String[] stringArray2 = new String[1];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[0] = stringArray[n];
            try {
                Hashtable hashtable2 = HscProviderUtils.doCSPCommand("GET_PROC_STATUS", stringArray2, hscProviderSocket);
                Integer n2 = (Integer)hashtable2.get("PROC_STATUS");
                hashtable.put(stringArray[n], n2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        return hashtable;
    }

    private static Hashtable _getProcState(HscProviderSocket hscProviderSocket, String[] stringArray) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        String[] stringArray2 = new String[1];
        int n = 0;
        while (n < stringArray.length) {
            try {
                stringArray2[0] = stringArray[n];
                Hashtable hashtable2 = HscProviderUtils.doCSPCommand("GET_PROC_STATE", stringArray2, hscProviderSocket);
                Integer n2 = (Integer)hashtable2.get("PROC_STATE");
                hashtable.put(stringArray[n], n2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        return hashtable;
    }

    public static CIMObjectPath buildFrameInstance(String string, CIMOMHandle cIMOMHandle, boolean bl, int n, int n2) throws CIMException {
        CIMObjectPath cIMObjectPath;
        Trace.trace("apcshscT", "-> buildFrameInstance");
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscV3_2");
            CIMClass cIMClass = cIMOMHandle.getClass(cIMObjectPath2, false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Frame"));
            cIMInstance.setProperty("Name", new CIMValue((Object)string));
            cIMInstance.setProperty("isFrame", new CIMValue((Object)new Boolean(bl)));
            cIMInstance.setProperty("frameType", new CIMValue((Object)new UnsignedInt16(n)));
            cIMInstance.setProperty("FrameNumber", new CIMValue((Object)new UnsignedInt8((short)n2)));
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            System.out.println("Creating the frame instance");
            CIMObjectPath cIMObjectPath4 = CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance);
            System.out.println(" after the Frame Creation.." + cIMObjectPath4);
            cIMObjectPath = cIMObjectPath4;
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                Object var12_13 = null;
                Trace.trace("apcshscT", "<- buildFrameInstance");
                throw throwable2;
            }
        }
        Trace.trace("apcshscT", "<- buildFrameInstance");
        return cIMObjectPath;
    }

    public static void buildFrameCecAss(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "-> buildFrameCecAss");
        try {
            try {
                CIMObjectPath cIMObjectPath3 = null;
                cIMObjectPath3 = new CIMObjectPath("IBMHSC_FrameCompSys", "root/ibmhscV3_2");
                CIMClass cIMClass = cIMOMHandle.getClass(cIMObjectPath3, false);
                CIMInstance cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
                cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
                System.out.println("Creating the Association between the Frame & CS");
                CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath4, cIMInstance);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException(throwable);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.trace("apcshscT", "<- buildFrameCecAss");
            throw throwable;
        }
        Trace.trace("apcshscT", "<- buildFrameCecAss");
    }
}

